package music;

import java.util.LinkedList;

public class Playlist {
	
	private LinkedList<Song> songs;
	
	public Playlist(LinkedList<Song> songs) {
		super();
		this.songs = songs;
	}
	
	public Playlist() {
		super();
		songs = new LinkedList<Song>();
	}

	public void addSong(Song song) {
		songs.push(song);
	}
	
	public void removeSong() {
		songs.pop();
	}
	
	public void removeSong(int i) {
		songs.remove(i);
	}
	
	public void removeSong(Song song) {
		songs.remove(song);
	}
	
	public void playAll() throws EmptyPlaylistException {
		if (songs.size() == 0) {
			throw new EmptyPlaylistException();
		}
		for (int i = 0; i < songs.size(); i++) {
			songs.get(i).display();
		}
	}
	
	public LinkedList<Song> getSongs() {
		return songs;
	}

	public void setSongs(LinkedList<Song> songs) {
		this.songs = songs;
	}

}
